"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateStories = void 0;
const project_name_1 = require("@nrwl/cypress/src/utils/project-name");
const devkit_1 = require("@nrwl/devkit");
const stories_1 = require("../../stories/stories");
function generateStories(tree, options) {
    const project = (0, devkit_1.readProjectConfiguration)(tree, options.name);
    const e2eProjectName = (0, project_name_1.getE2eProjectName)(options.name, project.root, options.cypressDirectory);
    (0, stories_1.angularStoriesGenerator)(tree, {
        name: options.name,
        generateCypressSpecs: options.configureCypress && options.generateCypressSpecs,
        cypressProject: e2eProjectName,
    });
}
exports.generateStories = generateStories;
//# sourceMappingURL=generate-stories.js.map