"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertCompatibleStorybookVersion = void 0;
const semver_1 = require("semver");
function assertCompatibleStorybookVersion() {
    let storybookVersion;
    try {
        storybookVersion = require(require.resolve('@storybook/angular/package.json')).version;
    }
    catch (_a) { }
    if (storybookVersion && (0, semver_1.lt)(storybookVersion, '6.4.0-rc.1')) {
        throw new Error('Incompatible Storybook Version: Please use a version of @storybook/angular higher than 6.4.0-rc.1');
    }
}
exports.assertCompatibleStorybookVersion = assertCompatibleStorybookVersion;
//# sourceMappingURL=assert-compatible-storybook-version.js.map