"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.angularStoriesGenerator = void 0;
const devkit_1 = require("@nrwl/devkit");
const project_type_1 = require("@nrwl/workspace/src/utilities/project-type");
const component_cypress_spec_1 = require("../component-cypress-spec/component-cypress-spec");
const component_story_1 = require("../component-story/component-story");
const component_info_1 = require("./lib/component-info");
const get_e2e_project_1 = require("./lib/get-e2e-project");
const module_info_1 = require("./lib/module-info");
function angularStoriesGenerator(tree, options) {
    var _a;
    const e2eProjectName = (_a = options.cypressProject) !== null && _a !== void 0 ? _a : `${options.name}-e2e`;
    const e2eProject = (0, get_e2e_project_1.getE2EProject)(tree, e2eProjectName);
    const projectPath = (0, project_type_1.getProjectRootPath)(tree, options.name);
    const moduleFilePaths = (0, module_info_1.getModuleFilePaths)(tree, projectPath);
    const componentsInfo = (0, component_info_1.getComponentsInfo)(tree, moduleFilePaths, options.name);
    if (options.generateCypressSpecs && !e2eProject) {
        devkit_1.logger.info(`There was no e2e project "${e2eProjectName}" found, so cypress specs will not be generated. Pass "--cypressProject" to specify a different e2e project name.`);
    }
    componentsInfo.forEach((info) => {
        if (info === undefined) {
            return;
        }
        (0, component_story_1.default)(tree, {
            projectPath: info.moduleFolderPath,
            componentName: info.name,
            componentPath: info.path,
            componentFileName: info.componentFileName,
        });
        if (options.generateCypressSpecs && e2eProject) {
            (0, component_cypress_spec_1.default)(tree, {
                projectName: options.name,
                projectPath: info.moduleFolderPath,
                cypressProject: options.cypressProject,
                componentName: info.name,
                componentPath: info.path,
                componentFileName: info.componentFileName,
            });
        }
    });
}
exports.angularStoriesGenerator = angularStoriesGenerator;
exports.default = angularStoriesGenerator;
//# sourceMappingURL=stories.js.map