"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllFilesRecursivelyFromDir = void 0;
const devkit_1 = require("@nrwl/devkit");
const ignore_1 = require("ignore");
function getAllFilesRecursivelyFromDir(tree, dir) {
    if (isPathIgnored(tree, dir)) {
        return [];
    }
    const files = [];
    const children = tree.children(dir);
    children.forEach((child) => {
        const childPath = (0, devkit_1.joinPathFragments)(dir, child);
        if (tree.isFile(childPath)) {
            files.push(childPath);
        }
        else {
            files.push(...getAllFilesRecursivelyFromDir(tree, childPath));
        }
    });
    return files;
}
exports.getAllFilesRecursivelyFromDir = getAllFilesRecursivelyFromDir;
function isPathIgnored(tree, path) {
    let ig;
    if (tree.exists('.gitignore')) {
        ig = (0, ignore_1.default)();
        ig.add(tree.read('.gitignore', 'utf-8'));
    }
    return path !== '' && (ig === null || ig === void 0 ? void 0 : ig.ignores(path));
}
//# sourceMappingURL=tree-utilities.js.map