"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupTailwindGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const lib_1 = require("./lib");
function setupTailwindGenerator(tree, rawOptions) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = (0, lib_1.normalizeOptions)(rawOptions);
        const project = (0, devkit_1.readProjectConfiguration)(tree, options.project);
        const tailwindInstalledVersion = (0, lib_1.detectTailwindInstalledVersion)(tree);
        let installTask = () => { };
        if (!options.skipPackageJson) {
            if (tailwindInstalledVersion === undefined) {
                installTask = (0, lib_1.addTailwindRequiredPackages)(tree);
            }
        }
        (0, lib_1.addTailwindConfig)(tree, options, project, tailwindInstalledVersion !== null && tailwindInstalledVersion !== void 0 ? tailwindInstalledVersion : '3');
        if (project.projectType === 'application') {
            (0, lib_1.updateApplicationStyles)(tree, options, project);
        }
        else if (project.projectType === 'library') {
            (0, lib_1.addTailwindConfigPathToProject)(tree, options, project);
        }
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
        return installTask;
    });
}
exports.setupTailwindGenerator = setupTailwindGenerator;
exports.default = setupTailwindGenerator;
//# sourceMappingURL=setup-tailwind.js.map