"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateApplicationStyles = void 0;
const devkit_1 = require("@nrwl/devkit");
function updateApplicationStyles(tree, options, project) {
    let stylesEntryPoint = options.stylesEntryPoint;
    if (stylesEntryPoint && !tree.exists(stylesEntryPoint)) {
        throw new Error(`The provided styles entry point "${stylesEntryPoint}" could not be found.`);
    }
    if (!stylesEntryPoint) {
        stylesEntryPoint = findStylesEntryPoint(tree, options, project);
        if (!stylesEntryPoint) {
            throw new Error((0, devkit_1.stripIndents) `Could not find a styles entry point for project "${options.project}".
        Please specify a styles entry point using the "--stylesEntryPoint" option.`);
        }
    }
    const stylesEntryPointContent = tree.read(stylesEntryPoint, 'utf-8');
    tree.write(stylesEntryPoint, (0, devkit_1.stripIndents) `@tailwind base;
    @tailwind components;
    @tailwind utilities;

    ${stylesEntryPointContent}`);
}
exports.updateApplicationStyles = updateApplicationStyles;
function findStylesEntryPoint(tree, options, project) {
    var _a, _b, _c, _d, _e, _f;
    // first check for common names
    const possibleStylesEntryPoints = [
        (0, devkit_1.joinPathFragments)((_a = project.sourceRoot) !== null && _a !== void 0 ? _a : project.root, 'styles.css'),
        (0, devkit_1.joinPathFragments)((_b = project.sourceRoot) !== null && _b !== void 0 ? _b : project.root, 'styles.scss'),
        (0, devkit_1.joinPathFragments)((_c = project.sourceRoot) !== null && _c !== void 0 ? _c : project.root, 'styles.sass'),
        (0, devkit_1.joinPathFragments)((_d = project.sourceRoot) !== null && _d !== void 0 ? _d : project.root, 'styles.less'),
    ];
    let stylesEntryPoint = possibleStylesEntryPoints.find((s) => tree.exists(s));
    if (stylesEntryPoint) {
        return stylesEntryPoint;
    }
    // then check for the specified styles in the build configuration if it exists
    const styles = (_f = (_e = project.targets) === null || _e === void 0 ? void 0 : _e[options.buildTarget].options) === null || _f === void 0 ? void 0 : _f.styles;
    if (!styles) {
        return undefined;
    }
    // find the first style that belongs to the project source
    const style = styles.find((s) => typeof s === 'string'
        ? s.startsWith(project.root) && tree.exists(s)
        : s.input.startsWith(project.root) &&
            s.inject !== false &&
            tree.exists(s.input));
    if (!style) {
        return undefined;
    }
    return typeof style === 'string' ? style : style.input;
}
//# sourceMappingURL=update-application-styles.js.map