"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectTailwindInstalledVersion = void 0;
const devkit_1 = require("@nrwl/devkit");
const version_utils_1 = require("@nrwl/workspace/src/utilities/version-utils");
const semver_1 = require("semver");
function detectTailwindInstalledVersion(tree) {
    var _a;
    const { dependencies, devDependencies } = (0, devkit_1.readJson)(tree, 'package.json');
    const tailwindVersion = (_a = dependencies === null || dependencies === void 0 ? void 0 : dependencies.tailwindcss) !== null && _a !== void 0 ? _a : devDependencies === null || devDependencies === void 0 ? void 0 : devDependencies.tailwindcss;
    if (!tailwindVersion) {
        return undefined;
    }
    const version = (0, version_utils_1.checkAndCleanWithSemver)('tailwindcss', tailwindVersion);
    if ((0, semver_1.lt)(version, '2.0.0')) {
        throw new Error(`The Tailwind CSS version "${tailwindVersion}" is not supported. Please upgrade to v2.0.0 or higher.`);
    }
    return (0, semver_1.lt)(version, '3.0.0') ? '2' : '3';
}
exports.detectTailwindInstalledVersion = detectTailwindInstalledVersion;
//# sourceMappingURL=detect-tailwind-installed-version.js.map