"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTailwindConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
const path_1 = require("path");
function addTailwindConfig(tree, options, project, tailwindVersion) {
    if (tree.exists((0, devkit_1.joinPathFragments)(project.root, 'tailwind.config.js'))) {
        throw new Error((0, devkit_1.stripIndents) `The "tailwind.config.js" file already exists in the project "${options.project}". Are you sure this is the right project to set up Tailwind?
      If you are sure, you can remove the existing file and re-run the generator.`);
    }
    const filesDir = tailwindVersion === '3' ? 'files/v3' : 'files/v2';
    (0, devkit_1.generateFiles)(tree, (0, devkit_1.joinPathFragments)(__dirname, '..', filesDir), project.root, {
        relativeSourceRoot: (0, path_1.relative)(project.root, project.sourceRoot),
        tmpl: '',
    });
}
exports.addTailwindConfig = addTailwindConfig;
//# sourceMappingURL=add-tailwind-config.js.map