"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTailwindConfigPathToProject = void 0;
const devkit_1 = require("@nrwl/devkit");
function addTailwindConfigPathToProject(tree, options, project) {
    var _a, _b;
    const buildTarget = (_a = project.targets) === null || _a === void 0 ? void 0 : _a[options.buildTarget];
    if (!buildTarget) {
        throw new Error((0, devkit_1.stripIndents) `The target "${options.buildTarget}" was not found for project "${options.project}".
      If you are using a different build target, please provide it using the "--buildTarget" option.
      If the project is not a buildable or publishable library, you don't need to setup TailwindCSS for it.`);
    }
    const supportedLibraryExecutors = [
        '@nrwl/angular:ng-packagr-lite',
        '@nrwl/angular:package',
    ];
    if (!supportedLibraryExecutors.includes(buildTarget.executor)) {
        throw new Error((0, devkit_1.stripIndents) `The build target for project "${options.project}" is using an unsupported executor "${buildTarget.executor}".
      Supported executors are ${supportedLibraryExecutors
            .map((e) => `"${e}"`)
            .join(', ')}.`);
    }
    if (((_b = buildTarget.options) === null || _b === void 0 ? void 0 : _b.tailwindConfig) &&
        tree.exists(buildTarget.options.tailwindConfig)) {
        throw new Error((0, devkit_1.stripIndents) `The "${buildTarget.options.tailwindConfig}" file is already configured for the project "${options.project}". Are you sure this is the right project to set up Tailwind?
      If you are sure, you can remove the configuration and re-run the generator.`);
    }
    buildTarget.options = Object.assign(Object.assign({}, buildTarget.options), { tailwindConfig: (0, devkit_1.joinPathFragments)(project.root, 'tailwind.config.js') });
    (0, devkit_1.updateProjectConfiguration)(tree, options.project, project);
}
exports.addTailwindConfigPathToProject = addTailwindConfigPathToProject;
//# sourceMappingURL=add-tailwind-config-path-to-project.js.map