"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupMfe = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const lib_1 = require("./lib");
function setupMfe(tree, options) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projectConfig = (0, devkit_1.readProjectConfiguration)(tree, options.appName);
        options.federationType = (_a = options.federationType) !== null && _a !== void 0 ? _a : 'static';
        (0, lib_1.setupHostIfDynamic)(tree, options);
        const remotesWithPorts = (0, lib_1.getRemotesWithPorts)(tree, options);
        (0, lib_1.addRemoteToHost)(tree, options);
        (0, lib_1.generateWebpackConfig)(tree, options, projectConfig.root, remotesWithPorts);
        (0, lib_1.addEntryModule)(tree, options, projectConfig.root);
        (0, lib_1.changeBuildTarget)(tree, options);
        (0, lib_1.updateTsConfigTarget)(tree, options);
        (0, lib_1.setupServeTarget)(tree, options);
        (0, lib_1.fixBootstrap)(tree, projectConfig.root, options);
        (0, lib_1.addCypressOnErrorWorkaround)(tree, options);
        // format files
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
    });
}
exports.setupMfe = setupMfe;
exports.default = setupMfe;
//# sourceMappingURL=setup-mfe.js.map