"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupServeTarget = void 0;
const devkit_1 = require("@nrwl/devkit");
function setupServeTarget(host, options) {
    var _a, _b;
    const appConfig = (0, devkit_1.readProjectConfiguration)(host, options.appName);
    appConfig.targets['serve'] = Object.assign(Object.assign({}, appConfig.targets['serve']), { executor: '@nrwl/angular:webpack-server', options: Object.assign(Object.assign({}, appConfig.targets['serve'].options), { port: (_a = options.port) !== null && _a !== void 0 ? _a : undefined, publicHost: `http://localhost:${(_b = options.port) !== null && _b !== void 0 ? _b : 4200}` }) });
    if (options.mfeType === 'host') {
        const remoteServeCommands = options.remotes
            ? options.remotes.map((r) => `nx serve ${r}`)
            : undefined;
        const commands = remoteServeCommands
            ? [...remoteServeCommands, `nx serve ${options.appName}`]
            : [`nx serve ${options.appName}`];
        appConfig.targets['serve-mfe'] = {
            executor: '@nrwl/workspace:run-commands',
            options: {
                commands,
            },
        };
    }
    (0, devkit_1.updateProjectConfiguration)(host, options.appName, appConfig);
    if (options.mfeType === 'remote' && options.host) {
        const hostAppConfig = (0, devkit_1.readProjectConfiguration)(host, options.host);
        hostAppConfig.targets['serve-mfe'] = Object.assign(Object.assign({}, hostAppConfig.targets['serve-mfe']), { options: Object.assign(Object.assign({}, hostAppConfig.targets['serve-mfe'].options), { commands: [
                    `nx serve ${options.appName}`,
                    ...hostAppConfig.targets['serve-mfe'].options.commands,
                ] }) });
        (0, devkit_1.updateProjectConfiguration)(host, options.host, hostAppConfig);
    }
}
exports.setupServeTarget = setupServeTarget;
//# sourceMappingURL=setup-serve-target.js.map