"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupHostIfDynamic = void 0;
const devkit_1 = require("@nrwl/devkit");
function setupHostIfDynamic(tree, options) {
    if (options.federationType === 'static' || options.mfeType === 'remote') {
        return;
    }
    const pathToMfeManifest = (0, devkit_1.joinPathFragments)((0, devkit_1.readProjectConfiguration)(tree, options.appName).sourceRoot, 'assets/mfe.manifest.json');
    if (!tree.exists(pathToMfeManifest)) {
        tree.write(pathToMfeManifest, '{}');
    }
}
exports.setupHostIfDynamic = setupHostIfDynamic;
//# sourceMappingURL=setup-host-if-dynamic.js.map