"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRemotesWithPorts = void 0;
const devkit_1 = require("@nrwl/devkit");
function getRemotesWithPorts(host, options) {
    var _a, _b, _c;
    // If type is host and remotes supplied, check remotes exist
    const remotesWithPort = [];
    if (options.mfeType === 'host' &&
        Array.isArray(options.remotes) &&
        options.remotes.length > 0) {
        for (const remote of options.remotes) {
            const remoteConfig = (0, devkit_1.readProjectConfiguration)(host, remote);
            remotesWithPort.push({
                remoteName: remote,
                port: (_c = (_b = (_a = remoteConfig.targets['serve']) === null || _a === void 0 ? void 0 : _a.options) === null || _b === void 0 ? void 0 : _b.port) !== null && _c !== void 0 ? _c : 4200,
            });
        }
    }
    return remotesWithPort;
}
exports.getRemotesWithPorts = getRemotesWithPorts;
//# sourceMappingURL=get-remotes-with-ports.js.map