"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateWebpackConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
function generateWebpackConfig(host, options, appRoot, remotesWithPorts) {
    if (host.exists(`${appRoot}/mfe.config.js`) ||
        host.exists(`${appRoot}/webpack.config.js`) ||
        host.exists(`${appRoot}/webpack.prod.config.js`)) {
        devkit_1.logger.warn(`NOTE: We encountered an existing webpack config for the app ${options.appName}. We have overwritten this file with the Module Federation Config.\n
      If this was not the outcome you expected, you can discard the changes we have made, create a backup of your current webpack config, and run the command again.`);
    }
    (0, devkit_1.generateFiles)(host, (0, devkit_1.joinPathFragments)(__dirname, '../files/webpack'), appRoot, {
        tmpl: '',
        type: options.mfeType,
        name: options.appName,
        remotes: remotesWithPorts !== null && remotesWithPorts !== void 0 ? remotesWithPorts : [],
        projectRoot: appRoot,
    });
}
exports.generateWebpackConfig = generateWebpackConfig;
//# sourceMappingURL=generate-config.js.map