"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fixBootstrap = void 0;
const devkit_1 = require("@nrwl/devkit");
function fixBootstrap(tree, appRoot, options) {
    const mainFilePath = (0, devkit_1.joinPathFragments)(appRoot, 'src/main.ts');
    const bootstrapCode = tree.read(mainFilePath, 'utf-8');
    tree.write((0, devkit_1.joinPathFragments)(appRoot, 'src/bootstrap.ts'), bootstrapCode);
    const bootstrapImportCode = `import('./bootstrap').catch(err => console.error(err))`;
    const fetchMfeManifestCode = `import { setRemoteDefinitions } from '@nrwl/angular/mfe';

  fetch('/assets/mfe.manifest.json')
  .then((res) => res.json())
  .then(definitions => setRemoteDefinitions(definitions))
  .then(() => ${bootstrapImportCode})`;
    tree.write(mainFilePath, options.mfeType === 'host' && options.federationType === 'dynamic'
        ? fetchMfeManifestCode
        : bootstrapImportCode);
}
exports.fixBootstrap = fixBootstrap;
//# sourceMappingURL=fix-bootstrap.js.map