"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.changeBuildTarget = void 0;
const devkit_1 = require("@nrwl/devkit");
function changeBuildTarget(host, options) {
    const appConfig = (0, devkit_1.readProjectConfiguration)(host, options.appName);
    appConfig.targets.build.executor = '@nrwl/angular:webpack-browser';
    appConfig.targets.build.options = Object.assign(Object.assign({}, appConfig.targets.build.options), { customWebpackConfig: {
            path: `${appConfig.root}/webpack.config.js`,
        } });
    appConfig.targets.build.configurations.production = Object.assign(Object.assign({}, appConfig.targets.build.configurations.production), { customWebpackConfig: {
            path: `${appConfig.root}/webpack.prod.config.js`,
        } });
    (0, devkit_1.updateProjectConfiguration)(host, options.appName, appConfig);
}
exports.changeBuildTarget = changeBuildTarget;
//# sourceMappingURL=change-build-target.js.map