"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRemoteToHost = exports.checkIsCommaNeeded = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const tsquery_1 = require("@phenomnomnominal/tsquery");
const ast_utils_1 = require("../../../utils/nx-devkit/ast-utils");
const ts = require("typescript");
const ast_utils_2 = require("@nrwl/workspace/src/utilities/ast-utils");
function checkIsCommaNeeded(mfeRemoteText) {
    const remoteText = mfeRemoteText.replace(/\s+/g, '');
    return !remoteText.endsWith(',]')
        ? remoteText === '[]'
            ? false
            : true
        : false;
}
exports.checkIsCommaNeeded = checkIsCommaNeeded;
function addRemoteToHost(tree, options) {
    if (options.mfeType === 'remote' && options.host) {
        const hostProject = (0, devkit_2.readProjectConfiguration)(tree, options.host);
        const pathToMfeManifest = (0, devkit_2.joinPathFragments)(hostProject.sourceRoot, 'assets/mfe.manifest.json');
        const hostFederationType = determineHostFederationType(tree, pathToMfeManifest);
        if (hostFederationType === 'static') {
            addRemoteToStaticHost(tree, options, hostProject);
        }
        else if (hostFederationType === 'dynamic') {
            addRemoteToDynamicHost(tree, options, pathToMfeManifest);
        }
        const declarationFilePath = (0, devkit_2.joinPathFragments)(hostProject.sourceRoot, 'decl.d.ts');
        const declarationFileContent = (tree.exists(declarationFilePath)
            ? tree.read(declarationFilePath, 'utf-8')
            : '') + `\ndeclare module '${options.appName}/Module';`;
        tree.write(declarationFilePath, declarationFileContent);
        addLazyLoadedRouteToHostAppModule(tree, options, hostFederationType);
    }
}
exports.addRemoteToHost = addRemoteToHost;
function determineHostFederationType(tree, pathToMfeManifest) {
    return tree.exists(pathToMfeManifest) ? 'dynamic' : 'static';
}
function addRemoteToStaticHost(tree, options, hostProject) {
    const hostMfeConfigPath = (0, devkit_2.joinPathFragments)(hostProject.root, 'mfe.config.js');
    if (!hostMfeConfigPath || !tree.exists(hostMfeConfigPath)) {
        throw new Error(`The selected host application, ${options.host}, does not contain a mfe.config.js or mfe.manifest.json file. Are you sure it has been set up as a host application?`);
    }
    const hostMFEConfig = tree.read(hostMfeConfigPath, 'utf-8');
    const webpackAst = tsquery_1.tsquery.ast(hostMFEConfig);
    const mfRemotesNode = (0, tsquery_1.tsquery)(webpackAst, 'Identifier[name=remotes] ~ ArrayLiteralExpression', { visitAllChildren: true })[0];
    const endOfPropertiesPos = mfRemotesNode.getEnd() - 1;
    const isCommaNeeded = checkIsCommaNeeded(mfRemotesNode.getText());
    const updatedConfig = `${hostMFEConfig.slice(0, endOfPropertiesPos)}${isCommaNeeded ? ',' : ''}'${options.appName}',${hostMFEConfig.slice(endOfPropertiesPos)}`;
    tree.write(hostMfeConfigPath, updatedConfig);
}
function addRemoteToDynamicHost(tree, options, pathToMfeManifest) {
    (0, devkit_1.updateJson)(tree, pathToMfeManifest, (manifest) => {
        return Object.assign(Object.assign({}, manifest), { [options.appName]: `http://localhost:${options.port}` });
    });
}
// TODO(colum): future work: allow dev to pass to path to routing module
function addLazyLoadedRouteToHostAppModule(tree, options, hostFederationType) {
    const hostAppConfig = (0, devkit_2.readProjectConfiguration)(tree, options.host);
    const pathToHostAppModule = `${hostAppConfig.sourceRoot}/app/app.module.ts`;
    if (!tree.exists(pathToHostAppModule)) {
        return;
    }
    const hostAppModule = tree.read(pathToHostAppModule, 'utf-8');
    if (!hostAppModule.includes('RouterModule.forRoot(')) {
        return;
    }
    let sourceFile = ts.createSourceFile(pathToHostAppModule, hostAppModule, ts.ScriptTarget.Latest, true);
    if (hostFederationType === 'dynamic') {
        sourceFile = (0, ast_utils_2.insertImport)(tree, sourceFile, pathToHostAppModule, 'loadRemoteModule', '@nrwl/angular/mfe');
    }
    const routeToAdd = hostFederationType === 'dynamic'
        ? `loadRemoteModule('${options.appName}', './Module')`
        : `import('${options.appName}/Module')`;
    sourceFile = (0, ast_utils_1.addRoute)(tree, pathToHostAppModule, sourceFile, `{
         path: '${options.appName}', 
         loadChildren: () => ${routeToAdd}.then(m => m.RemoteEntryModule)
     }`);
}
//# sourceMappingURL=add-remote-to-host.js.map