"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addEntryModule = void 0;
const devkit_1 = require("@nrwl/devkit");
function addEntryModule(host, { appName, routing, mfeType }, appRoot) {
    if (mfeType === 'remote') {
        const { npmScope } = (0, devkit_1.readWorkspaceConfiguration)(host);
        (0, devkit_1.generateFiles)(host, (0, devkit_1.joinPathFragments)(__dirname, '../files/entry-module-files'), `${appRoot}/src/app/remote-entry`, {
            tmpl: '',
            appName,
            npmScope,
            routing,
        });
        host.write(`${appRoot}/src/app/app.module.ts`, `/* 
      * This RemoteEntryModule is imported here to allow TS to find the Module during 
      * compilation, allowing it to be included in the built bundle. This is required 
      * for the Module Federation Plugin to expose the Module correctly.
      * */
      import { RemoteEntryModule } from './remote-entry/entry.module';
${host.read(`${appRoot}/src/app/app.module.ts`, 'utf-8')}`);
    }
}
exports.addEntryModule = addEntryModule;
//# sourceMappingURL=add-entry-module.js.map