"use strict";
// This is a temporary workaround to prevent cypress erroring
// as Angular attempt to figure out how to fix HMR when styles.js
// is attached to the index.html with type=module
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCypressOnErrorWorkaround = void 0;
const devkit_1 = require("@nrwl/devkit");
function addCypressOnErrorWorkaround(tree, schema) {
    var _a;
    const e2eProjectName = (_a = schema.e2eProjectName) !== null && _a !== void 0 ? _a : `${schema.appName}-e2e`;
    let e2eProject;
    try {
        e2eProject = (0, devkit_1.readProjectConfiguration)(tree, e2eProjectName);
    }
    catch (_b) {
        devkit_1.logger.warn(`Could not find an associated e2e project for ${schema.appName} with name ${e2eProjectName}. 
    If the app does have an associated Cypress e2e project, you can pass the name of it to the generator using --e2eProjectName.`);
        return;
    }
    if (e2eProject.targets.e2e.executor !== '@nrwl/cypress:cypress') {
        // Not a cypress e2e project, skip
        return;
    }
    const commandToAdd = `Cypress.on('uncaught:exception', err => {
    if (err.message.includes(\`Cannot use 'import.meta' outside a module\`)) {
      return false;
    }
    return true;
  });`;
    const pathToCommandsFile = (0, devkit_1.joinPathFragments)(e2eProject.sourceRoot, 'support/index.ts');
    const commandsContent = tree.exists(pathToCommandsFile)
        ? tree.read(pathToCommandsFile, 'utf-8')
        : '';
    tree.write(pathToCommandsFile, `${commandsContent}\n${commandToAdd}`);
}
exports.addCypressOnErrorWorkaround = addCypressOnErrorWorkaround;
//# sourceMappingURL=add-cypress-workaround.js.map