"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scamGenerator = void 0;
const tslib_1 = require("tslib");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const devkit_1 = require("@nrwl/devkit");
const create_module_1 = require("./lib/create-module");
const path_1 = require("../utils/path");
function scamGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { inlineScam } = schema, options = tslib_1.__rest(schema, ["inlineScam"]);
        checkPathUnderProjectRoot(tree, options);
        const angularComponentSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'component');
        yield angularComponentSchematic(tree, Object.assign(Object.assign({}, options), { skipImport: true, export: false }));
        (0, create_module_1.createScam)(tree, schema);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.scamGenerator = scamGenerator;
function checkPathUnderProjectRoot(tree, options) {
    var _a;
    if (!options.path) {
        return;
    }
    const project = (_a = options.project) !== null && _a !== void 0 ? _a : (0, devkit_1.readWorkspaceConfiguration)(tree).defaultProject;
    const { root } = (0, devkit_1.readProjectConfiguration)(tree, project);
    let pathToComponent = (0, devkit_1.normalizePath)(options.path);
    pathToComponent = pathToComponent.startsWith('/')
        ? pathToComponent.slice(1)
        : pathToComponent;
    if (!(0, path_1.pathStartsWith)(pathToComponent, root)) {
        throw new Error(`The path provided for the SCAM (${options.path}) does not exist under the project root (${root}).`);
    }
}
exports.default = scamGenerator;
//# sourceMappingURL=scam.js.map