"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createScam = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const typescript_1 = require("typescript");
function createScam(tree, schema) {
    var _a, _b, _c;
    const project = (_a = schema.project) !== null && _a !== void 0 ? _a : (0, devkit_2.readWorkspaceConfiguration)(tree).defaultProject;
    const projectConfig = (0, devkit_2.readProjectConfiguration)(tree, project);
    const componentNames = (0, devkit_2.names)(schema.name);
    const typeNames = (0, devkit_2.names)((_b = schema.type) !== null && _b !== void 0 ? _b : 'component');
    const componentFileName = `${componentNames.fileName}.${(_c = schema.type) !== null && _c !== void 0 ? _c : 'component'}`;
    let componentDirectory = schema.flat
        ? (0, devkit_2.joinPathFragments)(projectConfig.sourceRoot, projectConfig.projectType === 'application' ? 'app' : 'lib')
        : (0, devkit_2.joinPathFragments)(projectConfig.sourceRoot, projectConfig.projectType === 'application' ? 'app' : 'lib', componentNames.fileName);
    if (schema.path) {
        componentDirectory = schema.flat
            ? (0, devkit_2.normalizePath)(schema.path)
            : (0, devkit_2.joinPathFragments)(schema.path, componentNames.fileName);
    }
    const componentFilePath = (0, devkit_2.joinPathFragments)(componentDirectory, `${componentFileName}.ts`);
    if (!tree.exists(componentFilePath)) {
        throw new Error(`Couldn't find component at path ${componentFilePath} to add SCAM setup.`);
    }
    if (schema.inlineScam) {
        const currentComponentContents = tree.read(componentFilePath, 'utf-8');
        let source = (0, typescript_1.createSourceFile)(componentFilePath, currentComponentContents, typescript_1.ScriptTarget.Latest, true);
        source = (0, ast_utils_1.insertImport)(tree, source, componentFilePath, 'NgModule', '@angular/core');
        source = (0, ast_utils_1.insertImport)(tree, source, componentFilePath, 'CommonModule', '@angular/common');
        let updatedComponentSource = source.getText();
        updatedComponentSource = `${updatedComponentSource}${createAngularComponentModule(`${componentNames.className}${typeNames.className}`)}`;
        tree.write(componentFilePath, updatedComponentSource);
        exportScam(tree, schema, componentFilePath);
        return;
    }
    const scamFilePath = (0, devkit_2.joinPathFragments)(componentDirectory, `${componentNames.fileName}.module.ts`);
    tree.write(scamFilePath, createSeparateAngularComponentModuleFile(`${componentNames.className}${typeNames.className}`, componentFileName));
    exportScam(tree, schema, scamFilePath);
}
exports.createScam = createScam;
function exportScam(tree, schema, scamFilePath) {
    var _a, _b;
    if (!schema.export) {
        return;
    }
    const project = (_a = schema.project) !== null && _a !== void 0 ? _a : (0, devkit_2.readWorkspaceConfiguration)(tree).defaultProject;
    const { root, sourceRoot, projectType } = (0, devkit_2.readProjectConfiguration)(tree, project);
    if (projectType === 'application') {
        devkit_1.logger.warn('--export=true was ignored as the project the SCAM is being generated in is not a library.');
        return;
    }
    const ngPackageJsonPath = (0, devkit_2.joinPathFragments)(root, 'ng-package.json');
    const ngPackageEntryPoint = tree.exists(ngPackageJsonPath)
        ? (_b = (0, devkit_1.readJson)(tree, ngPackageJsonPath).lib) === null || _b === void 0 ? void 0 : _b.entryFile
        : undefined;
    const projectEntryPoint = ngPackageEntryPoint
        ? (0, devkit_2.joinPathFragments)(root, ngPackageEntryPoint)
        : (0, devkit_2.joinPathFragments)(sourceRoot, `index.ts`);
    if (!tree.exists(projectEntryPoint)) {
        // Let's not error, simply warn the user
        // It's not too much effort to manually do this
        // It would be more frustrating to have to find the correct path and re-run the command
        devkit_1.logger.warn(`Could not export SCAM. Unable to determine project's entry point. Path ${projectEntryPoint} does not exist. SCAM has still been created.`);
        return;
    }
    const relativePathFromEntryPoint = `.${scamFilePath
        .split(sourceRoot)[1]
        .replace('.ts', '')}`;
    const updateEntryPointContent = `${tree.read(projectEntryPoint, 'utf-8')}
  export * from "${relativePathFromEntryPoint}";`;
    tree.write(projectEntryPoint, updateEntryPointContent);
}
function createAngularComponentModule(name) {
    return `
@NgModule({
  imports: [CommonModule],
  declarations: [${name}],
  exports: [${name}],
})
export class ${name}Module {}`;
}
function createSeparateAngularComponentModuleFile(name, componentFileName) {
    return `import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ${name} } from './${componentFileName}';
${createAngularComponentModule(name)}`;
}
//# sourceMappingURL=create-module.js.map