"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scamPipeGenerator = void 0;
const tslib_1 = require("tslib");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const devkit_1 = require("@nrwl/devkit");
const create_module_1 = require("./lib/create-module");
const path_1 = require("../utils/path");
function scamPipeGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { inlineScam } = schema, options = tslib_1.__rest(schema, ["inlineScam"]);
        checkPathUnderProjectRoot(tree, options);
        const angularPipeSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'pipe');
        yield angularPipeSchematic(tree, Object.assign(Object.assign({}, options), { skipImport: true, export: false }));
        (0, create_module_1.createScamPipe)(tree, schema);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.scamPipeGenerator = scamPipeGenerator;
function checkPathUnderProjectRoot(tree, options) {
    var _a;
    if (!options.path) {
        return;
    }
    const project = (_a = options.project) !== null && _a !== void 0 ? _a : (0, devkit_1.readWorkspaceConfiguration)(tree).defaultProject;
    const { root } = (0, devkit_1.readProjectConfiguration)(tree, project);
    let pathToPipe = (0, devkit_1.normalizePath)(options.path);
    pathToPipe = pathToPipe.startsWith('/') ? pathToPipe.slice(1) : pathToPipe;
    if (!(0, path_1.pathStartsWith)(pathToPipe, root)) {
        throw new Error(`The path provided for the SCAM (${options.path}) does not exist under the project root (${root}).`);
    }
}
exports.default = scamPipeGenerator;
//# sourceMappingURL=scam-pipe.js.map