"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scamDirectiveGenerator = void 0;
const tslib_1 = require("tslib");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const devkit_1 = require("@nrwl/devkit");
const create_module_1 = require("./lib/create-module");
const path_1 = require("../utils/path");
function scamDirectiveGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { inlineScam } = schema, options = tslib_1.__rest(schema, ["inlineScam"]);
        checkPathUnderProjectRoot(tree, options);
        const angularDirectiveSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'directive');
        yield angularDirectiveSchematic(tree, Object.assign(Object.assign({}, options), { skipImport: true, export: false }));
        (0, create_module_1.createScamDirective)(tree, schema);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.scamDirectiveGenerator = scamDirectiveGenerator;
function checkPathUnderProjectRoot(tree, options) {
    var _a;
    if (!options.path) {
        return;
    }
    const project = (_a = options.project) !== null && _a !== void 0 ? _a : (0, devkit_1.readWorkspaceConfiguration)(tree).defaultProject;
    const { root } = (0, devkit_1.readProjectConfiguration)(tree, project);
    let pathToDirective = (0, devkit_1.normalizePath)(options.path);
    pathToDirective = pathToDirective.startsWith('/')
        ? pathToDirective.slice(1)
        : pathToDirective;
    if (!(0, path_1.pathStartsWith)(pathToDirective, root)) {
        throw new Error(`The path provided for the SCAM (${options.path}) does not exist under the project root (${root}).`);
    }
}
exports.default = scamDirectiveGenerator;
//# sourceMappingURL=scam-directive.js.map