"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ngrxGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const lib_1 = require("./lib");
function ngrxGenerator(tree, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const normalizedOptions = (0, lib_1.normalizeOptions)(options);
        if (!tree.exists(normalizedOptions.module)) {
            throw new Error(`Module does not exist: ${normalizedOptions.module}.`);
        }
        if (!normalizedOptions.minimal || !normalizedOptions.root) {
            (0, lib_1.generateNgrxFilesFromTemplates)(tree, normalizedOptions);
        }
        if (!normalizedOptions.skipImport) {
            (0, lib_1.addImportsToModule)(tree, normalizedOptions);
            (0, lib_1.addExportsToBarrel)(tree, normalizedOptions);
        }
        let packageInstallationTask = () => { };
        if (!normalizedOptions.skipPackageJson) {
            packageInstallationTask = (0, lib_1.addNgRxToPackageJson)(tree);
        }
        if (!normalizedOptions.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
        return packageInstallationTask;
    });
}
exports.ngrxGenerator = ngrxGenerator;
exports.default = ngrxGenerator;
//# sourceMappingURL=ngrx.js.map