"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateNgrxFilesFromTemplates = void 0;
const devkit_1 = require("@nrwl/devkit");
const path_1 = require("path");
/**
 * Generate 'feature' scaffolding: actions, reducer, effects, interfaces, selectors, facade
 */
function generateNgrxFilesFromTemplates(tree, options) {
    const name = options.name;
    const moduleDir = (0, path_1.dirname)(options.module);
    const templatesDir = !options.syntax || options.syntax === 'creators'
        ? './files/creator-syntax'
        : './files/classes-syntax';
    const projectNames = (0, devkit_1.names)(name);
    (0, devkit_1.generateFiles)(tree, (0, devkit_1.joinPathFragments)(__dirname, '..', templatesDir), moduleDir, Object.assign(Object.assign(Object.assign({}, options), { tmpl: '' }), projectNames));
    if (!options.facade) {
        tree.delete((0, devkit_1.joinPathFragments)(moduleDir, options.directory, `${projectNames.fileName}.facade.ts`));
        tree.delete((0, devkit_1.joinPathFragments)(moduleDir, options.directory, `${projectNames.fileName}.facade.spec.ts`));
    }
}
exports.generateNgrxFilesFromTemplates = generateNgrxFilesFromTemplates;
//# sourceMappingURL=generate-files.js.map