"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addNgRxToPackageJson = void 0;
const devkit_1 = require("@nrwl/devkit");
const semver_1 = require("semver");
const versions_1 = require("../../../utils/versions");
const version_utils_1 = require("@nrwl/workspace/src/utilities/version-utils");
function addNgRxToPackageJson(tree) {
    let rxjsVersion;
    try {
        rxjsVersion = (0, version_utils_1.checkAndCleanWithSemver)('rxjs', (0, devkit_1.readJson)(tree, 'package.json').dependencies['rxjs']);
    }
    catch (_a) {
        rxjsVersion = (0, version_utils_1.checkAndCleanWithSemver)('rxjs', versions_1.rxjsVersion);
    }
    const jasmineMarblesVersion = (0, semver_1.gte)(rxjsVersion, '7.0.0') ? '~0.9.1' : '~0.8.3';
    return (0, devkit_1.addDependenciesToPackageJson)(tree, {
        '@ngrx/store': versions_1.ngrxVersion,
        '@ngrx/effects': versions_1.ngrxVersion,
        '@ngrx/entity': versions_1.ngrxVersion,
        '@ngrx/router-store': versions_1.ngrxVersion,
        '@ngrx/component-store': versions_1.ngrxVersion,
    }, {
        '@ngrx/schematics': versions_1.ngrxVersion,
        '@ngrx/store-devtools': versions_1.ngrxVersion,
        'jasmine-marbles': jasmineMarblesVersion,
    });
}
exports.addNgRxToPackageJson = addNgRxToPackageJson;
//# sourceMappingURL=add-ngrx-to-package-json.js.map