"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addImportsToModule = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const typescript_1 = require("typescript");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addImportsToModule(tree, options) {
    const modulePath = options.module;
    const sourceText = tree.read(modulePath, 'utf-8');
    let sourceFile = (0, typescript_1.createSourceFile)(modulePath, sourceText, typescript_1.ScriptTarget.Latest, true);
    const addImport = (source, symbolName, fileName, isDefault = false) => {
        return (0, ast_utils_1.insertImport)(tree, source, modulePath, symbolName, fileName, isDefault);
    };
    const dir = `./${(0, devkit_1.names)(options.directory).fileName}`;
    const pathPrefix = `${dir}/${(0, devkit_1.names)(options.name).fileName}`;
    const reducerPath = `${pathPrefix}.reducer`;
    const effectsPath = `${pathPrefix}.effects`;
    const facadePath = `${pathPrefix}.facade`;
    const constantName = `${(0, devkit_1.names)(options.name).constantName}`;
    const effectsName = `${(0, devkit_1.names)(options.name).className}Effects`;
    const facadeName = `${(0, devkit_1.names)(options.name).className}Facade`;
    const className = `${(0, devkit_1.names)(options.name).className}`;
    const reducerImports = `* as from${className}`;
    const storeMetaReducers = `metaReducers: !environment.production ? [] : []`;
    const storeForRoot = `StoreModule.forRoot({}, {
      ${storeMetaReducers},
      runtimeChecks: {
        strictActionImmutability: true,
        strictStateImmutability: true
      }
    })`;
    const nxModule = 'NxModule.forRoot()';
    const effectsForRoot = `EffectsModule.forRoot([${effectsName}])`;
    const effectsForEmptyRoot = `EffectsModule.forRoot([])`;
    const storeForFeature = `StoreModule.forFeature(from${className}.${constantName}_FEATURE_KEY, from${className}.reducer)`;
    const effectsForFeature = `EffectsModule.forFeature([${effectsName}])`;
    const devTools = `!environment.production ? StoreDevtoolsModule.instrument() : []`;
    const storeRouterModule = 'StoreRouterConnectingModule.forRoot()';
    // this is just a heuristic
    const hasRouter = sourceText.indexOf('RouterModule') > -1;
    const hasNxModule = sourceText.includes(nxModule);
    sourceFile = addImport(sourceFile, 'StoreModule', '@ngrx/store');
    sourceFile = addImport(sourceFile, 'EffectsModule', '@ngrx/effects');
    if (options.minimal && options.root) {
        sourceFile = addImport(sourceFile, 'StoreDevtoolsModule', '@ngrx/store-devtools');
        sourceFile = addImport(sourceFile, 'environment', '../environments/environment');
        sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeForRoot);
        sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, effectsForEmptyRoot);
        sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, devTools);
        if (hasRouter) {
            sourceFile = addImport(sourceFile, 'StoreRouterConnectingModule', '@ngrx/router-store');
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeRouterModule);
        }
    }
    else {
        const addCommonImports = () => {
            sourceFile = addImport(sourceFile, reducerImports, reducerPath, true);
            sourceFile = addImport(sourceFile, effectsName, effectsPath);
            if (options.facade) {
                sourceFile = addImport(sourceFile, facadeName, facadePath);
                sourceFile = (0, ast_utils_2.addProviderToModule)(tree, sourceFile, modulePath, facadeName);
            }
            return sourceFile;
        };
        if (options.root) {
            sourceFile = addCommonImports();
            if (!hasNxModule) {
                sourceFile = addImport(sourceFile, 'NxModule', '@nrwl/angular');
                sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, nxModule);
            }
            sourceFile = addImport(sourceFile, 'StoreDevtoolsModule', '@ngrx/store-devtools');
            sourceFile = addImport(sourceFile, 'environment', '../environments/environment');
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeForRoot);
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, effectsForRoot);
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, devTools);
            if (hasRouter) {
                sourceFile = addImport(sourceFile, 'StoreRouterConnectingModule', '@ngrx/router-store');
                sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeRouterModule);
            }
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeForFeature);
        }
        else {
            sourceFile = addCommonImports();
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, storeForFeature);
            sourceFile = (0, ast_utils_2.addImportToModule)(tree, sourceFile, modulePath, effectsForFeature);
        }
    }
}
exports.addImportsToModule = addImportsToModule;
//# sourceMappingURL=add-imports-to-module.js.map