"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addExportsToBarrel = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const path_1 = require("path");
const typescript_1 = require("typescript");
/**
 * Add ngrx feature exports to the public barrel in the feature library
 */
function addExportsToBarrel(tree, options) {
    // Don't update the public barrel for the root state, only for feature states
    if (options.root) {
        return;
    }
    const indexFilePath = (0, devkit_1.joinPathFragments)((0, path_1.dirname)(options.module), '..', 'index.ts');
    if (!tree.exists(indexFilePath)) {
        return;
    }
    const indexSourceText = tree.read(indexFilePath, 'utf-8');
    let sourceFile = (0, typescript_1.createSourceFile)(indexFilePath, indexSourceText, typescript_1.ScriptTarget.Latest, true);
    // Public API for the feature interfaces, selectors, and facade
    const { className, fileName } = (0, devkit_1.names)(options.name);
    const statePath = `./lib/${options.directory}/${fileName}`;
    sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, options.barrels
        ? `import * as ${className}Actions from '${statePath}.actions';`
        : `export * from '${statePath}.actions';`);
    sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, options.barrels
        ? `import * as ${className}Feature from '${statePath}.reducer';`
        : `export * from '${statePath}.reducer';`);
    sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, options.barrels
        ? `import * as ${className}Selectors from '${statePath}.selectors';`
        : `export * from '${statePath}.selectors';`);
    if (options.barrels) {
        sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, `export { ${className}Actions, ${className}Feature, ${className}Selectors };`);
    }
    if (options.syntax === 'creators') {
        sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, `export * from '${statePath}.models';`);
    }
    if (options.facade) {
        sourceFile = (0, ast_utils_1.addGlobal)(tree, sourceFile, indexFilePath, `export * from '${statePath}.facade';`);
    }
}
exports.addExportsToBarrel = addExportsToBarrel;
//# sourceMappingURL=add-exports-barrel.js.map