"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectMigrator = void 0;
const devkit_1 = require("@nrwl/devkit");
const path_1 = require("path");
class ProjectMigrator {
    constructor(tree, options, project, rootDir) {
        var _a, _b, _c;
        this.tree = tree;
        this.options = options;
        this.projectConfig = project.config;
        this.project = {
            name: project.name,
            oldRoot: (_a = this.projectConfig.root) !== null && _a !== void 0 ? _a : '',
            oldSourceRoot: (_c = (_b = this.projectConfig.sourceRoot) !== null && _b !== void 0 ? _b : this.projectConfig.root) !== null && _c !== void 0 ? _c : '',
            newRoot: `${rootDir}/${project.name}`,
            newSourceRoot: `${rootDir}/${project.name}/src`,
        };
    }
    moveProjectRootFile(filePath, isRequired = true) {
        if (!filePath) {
            return;
        }
        const filename = !!filePath ? (0, path_1.basename)(filePath) : '';
        const from = filePath;
        const to = (0, devkit_1.joinPathFragments)(this.project.newRoot, filename);
        this.moveFile(from, to, isRequired);
    }
    moveDir(from, to) {
        (0, devkit_1.visitNotIgnoredFiles)(this.tree, from, (file) => {
            this.moveFile(file, file.replace(from, to), true);
        });
    }
    moveFile(from, to, required = true) {
        if (!this.tree.exists(from)) {
            if (required) {
                console.warn(`Path: ${from} does not exist`);
            }
        }
        else if (this.tree.exists(to)) {
            if (required) {
                console.warn(`Path: ${to} already exists`);
            }
        }
        else {
            const contents = this.tree.read(from);
            this.tree.write(to, contents);
            this.tree.delete(from);
        }
    }
}
exports.ProjectMigrator = ProjectMigrator;
//# sourceMappingURL=project.migrator.js.map