import { ProjectConfiguration, Tree } from '@nrwl/devkit';
import { GeneratorOptions } from '../schema';
import { MigrationProjectConfiguration, ValidationResult } from './types';
export declare abstract class ProjectMigrator {
    protected readonly tree: Tree;
    protected readonly options: GeneratorOptions;
    protected projectConfig: ProjectConfiguration;
    protected project: {
        name: string;
        oldRoot: string;
        oldSourceRoot: string;
        newRoot: string;
        newSourceRoot: string;
    };
    constructor(tree: Tree, options: GeneratorOptions, project: MigrationProjectConfiguration, rootDir: string);
    abstract migrate(): Promise<void>;
    abstract validate(): ValidationResult;
    protected moveProjectRootFile(filePath: string, isRequired?: boolean): void;
    protected moveDir(from: string, to: string): void;
    protected moveFile(from: string, to: string, required?: boolean): void;
}
