"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const devkit_1 = require("@nrwl/devkit");
function normalizeOptions(tree, options, projects) {
    var _a;
    let npmScope = (_a = options.npmScope) !== null && _a !== void 0 ? _a : options.name;
    if (npmScope) {
        npmScope = (0, devkit_1.names)(npmScope).fileName;
    }
    else if (projects.libs.length > 0) {
        // try get the scope from any library that have one
        for (const lib of projects.libs) {
            const { name } = (0, devkit_1.readJson)(tree, (0, devkit_1.joinPathFragments)(lib.config.root, 'package.json'));
            if (name.startsWith('@')) {
                npmScope = name.split('/')[0].substring(1);
                break;
            }
        }
    }
    if (!npmScope) {
        // use the name (scope if exists) in the root package.json
        const { name } = (0, devkit_1.readJson)(tree, 'package.json');
        npmScope = name.startsWith('@') ? name.split('/')[0].substring(1) : name;
    }
    return Object.assign(Object.assign({}, options), { npmScope });
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-options.js.map