"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllProjects = void 0;
const devkit_1 = require("@nrwl/devkit");
function getAllProjects(tree) {
    const projects = (0, devkit_1.getProjects)(tree);
    const result = {
        apps: [],
        libs: [],
    };
    for (const [name, project] of projects) {
        const migrationProject = {
            config: project,
            name,
        };
        if (project.projectType === 'library') {
            result.libs.push(migrationProject);
        }
        else {
            result.apps.push(migrationProject);
        }
    }
    return result;
}
exports.getAllProjects = getAllProjects;
//# sourceMappingURL=get-all-projects.js.map