"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isProtractorE2eProject = exports.isCypressE2eProject = exports.getCypressConfigFile = exports.getE2eProject = exports.getE2eKey = void 0;
const path_1 = require("path");
function getE2eKey(projects) {
    var _a;
    for (const project of projects.apps) {
        if ((_a = project.config.targets) === null || _a === void 0 ? void 0 : _a.e2e) {
            return project.name;
        }
    }
    return null;
}
exports.getE2eKey = getE2eKey;
function getE2eProject(projects) {
    var _a;
    for (const project of projects.apps) {
        if ((_a = project.config.targets) === null || _a === void 0 ? void 0 : _a.e2e) {
            return project;
        }
    }
    return null;
}
exports.getE2eProject = getE2eProject;
function getCypressConfigFile(e2eProject) {
    let cypressConfig = 'cypress.json';
    const configFileOption = e2eProject.targets.e2e.options.configFile;
    if (configFileOption === false) {
        cypressConfig = undefined;
    }
    else if (typeof configFileOption === 'string') {
        cypressConfig = (0, path_1.basename)(configFileOption);
    }
    return cypressConfig;
}
exports.getCypressConfigFile = getCypressConfigFile;
function isCypressE2eProject(e2eProject) {
    return e2eProject.targets.e2e.executor === '@cypress/schematic:cypress';
}
exports.isCypressE2eProject = isCypressE2eProject;
function isProtractorE2eProject(e2eProject) {
    return (e2eProject.targets.e2e.executor ===
        '@angular-devkit/build-angular:protractor');
}
exports.isProtractorE2eProject = isProtractorE2eProject;
//# sourceMappingURL=e2e-utils.js.map