"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ngAddGenerator = void 0;
const tslib_1 = require("tslib");
const init_1 = require("../init/init");
const migrate_from_angular_cli_1 = require("./migrate-from-angular-cli");
function getWorkspaceType(tree) {
    return tree.exists('nx.json') ? 'nx' : 'angular';
}
function ngAddGenerator(tree, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (getWorkspaceType(tree) === 'angular') {
            return yield (0, migrate_from_angular_cli_1.migrateFromAngularCli)(tree, options);
        }
        return yield (0, init_1.angularInitGenerator)(tree, options);
    });
}
exports.ngAddGenerator = ngAddGenerator;
exports.default = ngAddGenerator;
//# sourceMappingURL=ng-add.js.map