"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.migrateFromAngularCli = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const versions_1 = require("../../utils/versions");
const app_migrator_1 = require("./utilities/app.migrator");
const get_all_projects_1 = require("./utilities/get-all-projects");
const normalize_options_1 = require("./utilities/normalize-options");
const workspace_1 = require("./utilities/workspace");
function migrateFromAngularCli(tree, rawOptions) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, get_all_projects_1.getAllProjects)(tree);
        const options = (0, normalize_options_1.normalizeOptions)(tree, rawOptions, projects);
        if (options.preserveAngularCliLayout) {
            (0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
                nx: versions_1.nxVersion,
                '@nrwl/workspace': versions_1.nxVersion,
            });
            (0, workspace_1.createNxJson)(tree, options, true);
            (0, workspace_1.decorateAngularCli)(tree);
        }
        else {
            (0, workspace_1.validateWorkspace)(tree, projects);
            const migrators = [
                ...projects.apps.map((app) => new app_migrator_1.AppMigrator(tree, options, app)),
                // TODO: add libraries migrator when support for libs is added
            ];
            // TODO: validate all projects and collect errors before migrating when
            // multiple projects are supported
            // create and update root files and configurations
            (0, devkit_1.updateJson)(tree, 'angular.json', (json) => (Object.assign(Object.assign({}, json), { version: 2, $schema: undefined })));
            (0, workspace_1.createNxJson)(tree, options);
            (0, workspace_1.updateWorkspaceConfigDefaults)(tree);
            (0, workspace_1.updateRootTsConfig)(tree);
            (0, workspace_1.updatePackageJson)(tree);
            (0, workspace_1.decorateAngularCli)(tree);
            // TODO: check later if it's still needed
            (0, workspace_1.updateTsLint)(tree);
            yield (0, workspace_1.createWorkspaceFiles)(tree);
            // migrate all projects
            for (const migrator of migrators) {
                yield migrator.migrate();
            }
            // needs to be done last because the Angular CLI workspace can have one
            // in the root for the root application, so we wait until that root Karma
            // config is moved when the projects are migrated before creating this one
            (0, workspace_1.createRootKarmaConfig)(tree);
            yield (0, devkit_1.formatFiles)(tree);
        }
        if (!options.skipInstall) {
            return () => {
                (0, devkit_1.installPackagesTask)(tree);
            };
        }
    });
}
exports.migrateFromAngularCli = migrateFromAngularCli;
//# sourceMappingURL=migrate-from-angular-cli.js.map