"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.angularMoveSchematic = exports.angularMoveGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const generators_1 = require("@nrwl/workspace/generators");
const update_module_name_1 = require("./lib/update-module-name");
const update_ng_package_1 = require("./lib/update-ng-package");
/**
 * Moves an Angular lib/app to another folder (and renames it in the process)
 *
 * @remarks It's important to note that `updateModuleName` is done after the update
 * to the workspace, so it can't use the same tricks as the `@nrwl/workspace` rules
 * to get the before and after names and paths.
 */
function angularMoveGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield (0, generators_1.moveGenerator)(tree, Object.assign(Object.assign({}, schema), { skipFormat: true }));
        (0, update_module_name_1.updateModuleName)(tree, schema);
        (0, update_ng_package_1.updateNgPackage)(tree, schema);
        if (!schema.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
    });
}
exports.angularMoveGenerator = angularMoveGenerator;
exports.angularMoveSchematic = (0, devkit_1.convertNxGenerator)(angularMoveGenerator);
//# sourceMappingURL=move.js.map