"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateNgPackage = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const utils_1 = require("@nrwl/workspace/src/generators/move/lib/utils");
const path_1 = require("path");
function updateNgPackage(tree, schema) {
    var _a, _b, _c;
    const newProjectName = (0, utils_1.getNewProjectName)(schema.destination);
    const project = (0, devkit_1.readProjectConfiguration)(tree, newProjectName);
    if (project.projectType === 'application') {
        return;
    }
    const ngPackagePath = `${project.root}/ng-package.json`;
    if (!tree.exists(ngPackagePath)) {
        return;
    }
    const rootOffset = (0, path_1.relative)((0, path_1.join)(devkit_2.workspaceRoot, project.root), devkit_2.workspaceRoot);
    let output = `dist/${project.root}`;
    if (((_c = (_b = (_a = project.targets) === null || _a === void 0 ? void 0 : _a.build) === null || _b === void 0 ? void 0 : _b.outputs) === null || _c === void 0 ? void 0 : _c.length) > 0) {
        output = project.targets.build.outputs[0];
    }
    (0, devkit_1.updateJson)(tree, ngPackagePath, (json) => {
        json.dest = `${rootOffset}/${output}`;
        return json;
    });
}
exports.updateNgPackage = updateNgPackage;
//# sourceMappingURL=update-ng-package.js.map