"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const application_1 = require("../application/application");
const get_mfe_projects_1 = require("../../utils/get-mfe-projects");
function findNextAvailablePort(tree) {
    var _a, _b, _c;
    const mfeProjects = (0, get_mfe_projects_1.getMfeProjects)(tree);
    const ports = new Set([4200]);
    for (const mfeProject of mfeProjects) {
        const { targets } = (0, devkit_1.readProjectConfiguration)(tree, mfeProject);
        const port = (_c = (_b = (_a = targets === null || targets === void 0 ? void 0 : targets.serve) === null || _a === void 0 ? void 0 : _a.options) === null || _b === void 0 ? void 0 : _b.port) !== null && _c !== void 0 ? _c : 4200;
        ports.add(port);
    }
    const nextAvailablePort = Math.max(...ports) + 1;
    return nextAvailablePort;
}
function mfeRemote(tree, options) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        if (options.host && !projects.has(options.host)) {
            throw new Error(`The name of the application to be used as the host app does not exist. (${options.host})`);
        }
        const installTask = yield (0, application_1.default)(tree, Object.assign(Object.assign({}, options), { mfe: true, mfeType: 'remote', routing: true, host: options.host, port: (_a = options.port) !== null && _a !== void 0 ? _a : findNextAvailablePort(tree) }));
        return installTask;
    });
}
exports.default = mfeRemote;
//# sourceMappingURL=mfe-remote.js.map