"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const application_1 = require("../application/application");
function mfeHost(tree, options) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        if (options.remotes && options.remotes.length > 0) {
            options.remotes.forEach((remote) => {
                if (!projects.has(remote)) {
                    throw new Error(`Could not find specified remote application (${remote})`);
                }
            });
        }
        const installTask = yield (0, application_1.default)(tree, Object.assign(Object.assign({}, options), { mfe: true, mfeType: 'host', routing: true, remotes: (_a = options.remotes) !== null && _a !== void 0 ? _a : [], port: 4200, federationType: options.dynamic ? 'dynamic' : 'static' }));
        return installTask;
    });
}
exports.default = mfeHost;
//# sourceMappingURL=mfe-host.js.map