"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTsConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
function updateRootConfig(host, options) {
    (0, devkit_1.updateJson)(host, (0, typescript_1.getRootTsConfigPathInTree)(host), (json) => {
        const c = json.compilerOptions;
        c.paths = c.paths || {};
        delete c.paths[options.name];
        if (c.paths[options.importPath]) {
            throw new Error(`You already have a library using the import path "${options.importPath}". Make sure to specify a unique one.`);
        }
        c.paths[options.importPath] = [
            (0, devkit_1.joinPathFragments)((0, devkit_1.getWorkspaceLayout)(host).libsDir, options.projectDirectory, '/src/index.ts'),
        ];
        return json;
    });
}
function updateProjectConfig(host, options) {
    (0, devkit_1.updateJson)(host, `${options.projectRoot}/tsconfig.lib.json`, (json) => {
        json.include = ['**/*.ts'];
        json.exclude = [
            ...new Set([...(json.exclude || []), '**/*.test.ts', '**/*.spec.ts']),
        ];
        return json;
    });
}
function updateProjectIvyConfig(host, options) {
    if (options.buildable || options.publishable) {
        return (0, devkit_1.updateJson)(host, `${options.projectRoot}/tsconfig.lib.prod.json`, (json) => {
            json.angularCompilerOptions['compilationMode'] =
                options.compilationMode === 'full' ? undefined : 'partial';
            return json;
        });
    }
}
function updateTsConfig(host, options) {
    updateRootConfig(host, options);
    updateProjectConfig(host, options);
    updateProjectIvyConfig(host, options);
}
exports.updateTsConfig = updateTsConfig;
//# sourceMappingURL=update-tsconfig.js.map