"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateProject = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const cli_config_utils_1 = require("@nrwl/workspace/src/utils/cli-config-utils");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const path = require("path");
const update_ng_package_1 = require("./update-ng-package");
function updateProject(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        createFiles(host, options);
        updateProjectTsConfig(host, options);
        fixProjectWorkspaceConfig(host, options);
        (0, update_ng_package_1.updateNgPackage)(host, options);
        updateFiles(host, options);
    });
}
exports.updateProject = updateProject;
function updateFiles(host, options) {
    const libRoot = `${options.projectRoot}/src/lib/`;
    const serviceSpecPath = path.join(libRoot, `${options.name}.service.spec.ts`);
    const componentSpecPath = path.join(libRoot, `${options.name}.component.spec.ts`);
    host.delete(path.join(libRoot, `${options.name}.service.ts`));
    if (host.exists(serviceSpecPath)) {
        host.delete(serviceSpecPath);
    }
    host.delete(path.join(libRoot, `${options.name}.component.ts`));
    if (host.exists(componentSpecPath)) {
        host.delete(path.join(libRoot, `${options.name}.component.spec.ts`));
    }
    if (!options.publishable && !options.buildable) {
        host.delete(path.join(options.projectRoot, 'ng-package.json'));
        host.delete(path.join(options.projectRoot, 'package.json'));
        host.delete(path.join(options.projectRoot, 'tsconfig.lib.prod.json'));
        host.delete(path.join(options.projectRoot, '.browserslistrc'));
    }
    host.delete(path.join(options.projectRoot, 'karma.conf.js'));
    host.delete(path.join(options.projectRoot, 'src/test.ts'));
    host.delete(path.join(options.projectRoot, 'tsconfig.spec.json'));
    if (options.name !== options.fileName) {
        host.delete(path.join(libRoot, `${options.name}.module.ts`));
    }
    if (!options.skipModule) {
        host.write(path.join(libRoot, `${options.fileName}.module.ts`), `
        import { NgModule } from '@angular/core';
        import { CommonModule } from '@angular/common';
        
        @NgModule({
          imports: [
            CommonModule
          ]
        })
        export class ${options.moduleName} { }
        `);
        if (options.unitTestRunner !== 'none' && options.addModuleSpec) {
            host.write(path.join(libRoot, `${options.fileName}.module.spec.ts`), `
    import { async, TestBed } from '@angular/core/testing';
    import { ${options.moduleName} } from './${options.fileName}.module';
    
    describe('${options.moduleName}', () => {
      beforeEach(async(() => {
        TestBed.configureTestingModule({
          imports: [ ${options.moduleName} ]
        })
        .compileComponents();
      }));
    
      // TODO: Add real tests here.
      //
      // NB: This particular test does not do anything useful. 
      //     It does NOT check for correct instantiation of the module.
      it('should have a module definition', () => {
        expect(${options.moduleName}).toBeDefined();
      });
    });
          `);
        }
    }
    else {
        host.delete((0, devkit_1.joinPathFragments)(libRoot, `${options.fileName}.module.ts`));
    }
    host.write(`${options.projectRoot}/src/index.ts`, options.skipModule
        ? ``
        : `
        export * from './lib/${options.fileName}.module';
        `);
}
function createFiles(host, options) {
    (0, devkit_1.generateFiles)(host, path.join(__dirname, '../files/lib'), options.projectRoot, Object.assign(Object.assign({}, options), { rootTsConfigPath: (0, typescript_1.getRelativePathToRootTsConfig)(host, options.projectRoot), tpl: '' }));
}
function fixProjectWorkspaceConfig(host, options) {
    let project = (0, devkit_1.readProjectConfiguration)(host, options.name);
    project.tags = options.parsedTags;
    if (options.ngCliSchematicLibRoot !== options.projectRoot) {
        project = (0, cli_config_utils_1.replaceAppNameWithPath)(project, options.ngCliSchematicLibRoot, options.projectRoot);
    }
    if (!options.publishable && !options.buildable) {
        delete project.targets.build;
    }
    else {
        // Set the right builder for the type of library.
        // Ensure the outputs property comes after the builder for
        // better readability.
        const _a = project.targets.build, { executor } = _a, rest = tslib_1.__rest(_a, ["executor"]);
        project.targets.build = Object.assign({ executor: options.publishable
                ? '@nrwl/angular:package'
                : '@nrwl/angular:ng-packagr-lite', outputs: [
                (0, devkit_1.joinPathFragments)('dist', (0, devkit_1.getWorkspaceLayout)(host).libsDir, options.projectDirectory),
            ] }, rest);
    }
    delete project.targets.test;
    (0, devkit_1.updateProjectConfiguration)(host, options.name, project);
}
function updateProjectTsConfig(host, options) {
    if (!host.exists(`${options.projectRoot}/tsconfig.lib.json`)) {
        host.write(`${options.projectRoot}/tsconfig.lib.json`, '{}');
    }
    (0, devkit_1.updateJson)(host, `${options.projectRoot}/tsconfig.lib.json`, (json) => {
        if (options.unitTestRunner === 'jest') {
            json.exclude = ['src/test-setup.ts', '**/*.spec.ts'];
        }
        else if (options.unitTestRunner === 'none') {
            json.exclude = [];
        }
        else {
            json.exclude = json.exclude || [];
        }
        return Object.assign(Object.assign({}, json), { extends: `./tsconfig.json`, compilerOptions: Object.assign(Object.assign({}, json.compilerOptions), { outDir: `${(0, devkit_1.offsetFromRoot)(options.projectRoot)}dist/out-tsc` }) });
    });
}
//# sourceMappingURL=update-project.js.map