"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateNgPackage = void 0;
const devkit_1 = require("@nrwl/devkit");
function updateNgPackage(host, options) {
    if (!(options.publishable || options.buildable)) {
        return;
    }
    const dest = (0, devkit_1.joinPathFragments)((0, devkit_1.offsetFromRoot)(options.projectRoot), 'dist', (0, devkit_1.getWorkspaceLayout)(host).libsDir, options.projectDirectory);
    (0, devkit_1.updateJson)(host, `${options.projectRoot}/ng-package.json`, (json) => {
        let $schema = json.$schema;
        if (json.$schema && json.$schema.indexOf('node_modules') >= 0) {
            $schema = `${(0, devkit_1.offsetFromRoot)(options.projectRoot)}${json.$schema.substring(json.$schema.indexOf('node_modules'), json.$schema.length)}`;
        }
        return Object.assign(Object.assign({}, json), { dest,
            $schema });
    });
}
exports.updateNgPackage = updateNgPackage;
//# sourceMappingURL=update-ng-package.js.map