"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const linter_1 = require("@nrwl/linter");
function normalizeOptions(host, schema) {
    var _a, _b, _c, _d, _e, _f;
    // Create a schema with populated default values
    const options = Object.assign({ buildable: false, linter: linter_1.Linter.EsLint, name: '', publishable: false, simpleModuleName: false, skipFormat: false, unitTestRunner: "jest" /* Jest */, 
        // Publishable libs cannot use `full` yet, so if its false then use the passed value or default to `full`
        compilationMode: schema.publishable
            ? 'partial'
            : (_a = schema.compilationMode) !== null && _a !== void 0 ? _a : 'full', skipModule: (_b = schema.skipModule) !== null && _b !== void 0 ? _b : false }, schema);
    const name = (0, devkit_2.names)(options.name).fileName;
    const projectDirectory = options.directory
        ? `${(0, devkit_2.names)(options.directory).fileName}/${name}`.replace(/\/+/g, '/')
        : name;
    const { libsDir, npmScope, standaloneAsDefault } = (0, devkit_1.getWorkspaceLayout)(host);
    const projectName = projectDirectory
        .replace(new RegExp('/', 'g'), '-')
        .replace(/-\d+/g, '');
    const fileName = options.simpleModuleName ? name : projectName;
    const projectRoot = (0, devkit_1.joinPathFragments)(libsDir, projectDirectory);
    const moduleName = `${(0, devkit_2.names)(fileName).className}Module`;
    const parsedTags = options.tags
        ? options.tags.split(',').map((s) => s.trim())
        : [];
    const modulePath = `${projectRoot}/src/lib/${fileName}.module.ts`;
    const defaultPrefix = npmScope;
    options.standaloneConfig = (_c = options.standaloneConfig) !== null && _c !== void 0 ? _c : standaloneAsDefault;
    const importPath = options.importPath || `@${defaultPrefix}/${projectDirectory}`;
    // Determine the roots where @schematics/angular will place the projects
    // This might not be where the projects actually end up
    const workspaceJsonPath = (0, devkit_1.getWorkspacePath)(host);
    let newProjectRoot = null;
    if (workspaceJsonPath) {
        ({ newProjectRoot } = (0, devkit_1.readJson)(host, workspaceJsonPath));
    }
    const ngCliSchematicLibRoot = newProjectRoot
        ? `${newProjectRoot}/${projectName}`
        : projectName;
    return Object.assign(Object.assign({}, options), { linter: (_d = options.linter) !== null && _d !== void 0 ? _d : linter_1.Linter.EsLint, unitTestRunner: (_e = options.unitTestRunner) !== null && _e !== void 0 ? _e : "jest" /* Jest */, prefix: (_f = options.prefix) !== null && _f !== void 0 ? _f : defaultPrefix, name: projectName, projectRoot, entryFile: 'index', moduleName,
        projectDirectory,
        modulePath,
        parsedTags,
        fileName,
        importPath,
        ngCliSchematicLibRoot });
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-options.js.map