"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setLibraryStrictDefault = exports.enableStrictTypeChecking = void 0;
const devkit_1 = require("@nrwl/devkit");
/**
 * Enable Strict Mode in the library and spec TS Config
 * */
function enableStrictTypeChecking(host, options) {
    updateTsConfig(host, options);
}
exports.enableStrictTypeChecking = enableStrictTypeChecking;
function setLibraryStrictDefault(host, isStrict) {
    var _a;
    // set the default so future libraries use it
    // unless the user has previously set this value
    const workspace = (0, devkit_1.readWorkspaceConfiguration)(host);
    workspace.generators = workspace.generators || {};
    workspace.generators['@nrwl/angular:library'] =
        workspace.generators['@nrwl/angular:library'] || {};
    workspace.generators['@nrwl/angular:library'].strict =
        (_a = workspace.generators['@nrwl/angular:library'].strict) !== null && _a !== void 0 ? _a : isStrict;
    (0, devkit_1.updateWorkspaceConfiguration)(host, workspace);
}
exports.setLibraryStrictDefault = setLibraryStrictDefault;
function updateTsConfig(host, options) {
    // Update the settings in the tsconfig.app.json to enable strict type checking.
    // This matches the settings defined by the Angular CLI https://angular.io/guide/strict-mode
    (0, devkit_1.updateJson)(host, `${options.projectRoot}/tsconfig.json`, (json) => {
        var _a, _b;
        // update the TypeScript settings
        json.compilerOptions = Object.assign(Object.assign({}, ((_a = json.compilerOptions) !== null && _a !== void 0 ? _a : {})), { forceConsistentCasingInFileNames: true, strict: true, noImplicitOverride: true, noPropertyAccessFromIndexSignature: true, noImplicitReturns: true, noFallthroughCasesInSwitch: true });
        // update Angular Template Settings
        json.angularCompilerOptions = Object.assign(Object.assign({}, ((_b = json.angularCompilerOptions) !== null && _b !== void 0 ? _b : {})), { strictInjectionParameters: true, strictInputAccessModifiers: true, strictTemplates: true });
        return json;
    });
}
//# sourceMappingURL=enable-strict-type-checking.js.map