"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRouterConfiguration = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ts = require("typescript");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addRouterConfiguration(host, options) {
    const constName = `${(0, devkit_1.names)(options.fileName).propertyName}Routes`;
    const moduleSource = host.read(options.modulePath).toString('utf-8');
    let moduleSourceFile = ts.createSourceFile(options.modulePath, moduleSource, ts.ScriptTarget.Latest, true);
    moduleSourceFile = (0, ast_utils_2.addImportToModule)(host, moduleSourceFile, options.modulePath, `RouterModule`);
    moduleSourceFile = (0, ast_utils_1.insertImport)(host, moduleSourceFile, options.modulePath, 'RouterModule, Route', '@angular/router');
    moduleSourceFile = (0, ast_utils_1.addGlobal)(host, moduleSourceFile, options.modulePath, `export const ${constName}: Route[] = [];`);
}
exports.addRouterConfiguration = addRouterConfiguration;
//# sourceMappingURL=add-router-configuration.js.map