"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addModule = void 0;
const add_children_1 = require("./add-children");
const add_lazy_loaded_router_configuration_1 = require("./add-lazy-loaded-router-configuration");
const add_load_children_1 = require("./add-load-children");
const add_router_configuration_1 = require("./add-router-configuration");
function addModule(host, options) {
    if (options.routing && options.lazy) {
        (0, add_lazy_loaded_router_configuration_1.addLazyLoadedRouterConfiguration)(host, options);
    }
    if (options.routing && options.lazy && options.parentModule) {
        (0, add_load_children_1.addLoadChildren)(host, options);
    }
    if (options.routing && !options.lazy) {
        (0, add_router_configuration_1.addRouterConfiguration)(host, options);
    }
    if (options.routing && !options.lazy && options.parentModule) {
        (0, add_children_1.addChildren)(host, options);
    }
}
exports.addModule = addModule;
//# sourceMappingURL=add-module.js.map