"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addLoadChildren = void 0;
const devkit_1 = require("@nrwl/devkit");
const path = require("path");
const ts = require("typescript");
const ast_utils_1 = require("../../../utils/nx-devkit/ast-utils");
function addLoadChildren(host, options) {
    if (!host.exists(options.parentModule)) {
        throw new Error(`Cannot find '${options.parentModule}'`);
    }
    const moduleSource = host.read(options.parentModule).toString('utf-8');
    let sourceFile = ts.createSourceFile(options.parentModule, moduleSource, ts.ScriptTarget.Latest, true);
    sourceFile = (0, ast_utils_1.addRoute)(host, options.parentModule, sourceFile, `{path: '${(0, devkit_1.names)(options.fileName).fileName}', loadChildren: () => import('${options.importPath}').then(module => module.${options.moduleName})}`);
    const tsConfig = findClosestTsConfigApp(host, options.parentModule);
    if (tsConfig) {
        const offset = (0, devkit_1.offsetFromRoot)(path.dirname(tsConfig));
        (0, devkit_1.updateJson)(host, tsConfig, (json) => {
            var _a;
            json.include = (_a = json.include) !== null && _a !== void 0 ? _a : [];
            json.include = [
                ...json.include,
                `${offset}${options.projectRoot}/src/index.ts`,
            ];
            return json;
        });
    }
    else {
        console.warn(`Unable to find tsconfig.json for ${options.parentModule}. Related \`includes\` for the tsconfig have not been updated.`);
    }
}
exports.addLoadChildren = addLoadChildren;
function findClosestTsConfigApp(host, parentModule) {
    const dir = path.parse(parentModule).dir;
    if (host.exists(`${dir}/tsconfig.app.json`)) {
        return `${dir}/tsconfig.app.json`;
    }
    else if (dir != '') {
        return findClosestTsConfigApp(host, dir);
    }
    else {
        return null;
    }
}
//# sourceMappingURL=add-load-children.js.map