"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addLazyLoadedRouterConfiguration = void 0;
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ts = require("typescript");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addLazyLoadedRouterConfiguration(host, options) {
    const moduleSource = host.read(options.modulePath).toString('utf-8');
    let sourceFile = ts.createSourceFile(options.modulePath, moduleSource, ts.ScriptTarget.Latest, true);
    sourceFile = (0, ast_utils_2.addImportToModule)(host, sourceFile, options.modulePath, `
    RouterModule.forChild([
      /* {path: '', pathMatch: 'full', component: InsertYourComponentHere} */
    ]) `);
    sourceFile = (0, ast_utils_1.insertImport)(host, sourceFile, options.modulePath, 'RouterModule', '@angular/router');
}
exports.addLazyLoadedRouterConfiguration = addLazyLoadedRouterConfiguration;
//# sourceMappingURL=add-lazy-loaded-router-configuration.js.map