"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addChildren = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ts = require("typescript");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addChildren(host, options) {
    if (!host.exists(options.parentModule)) {
        throw new Error(`Cannot find '${options.parentModule}'`);
    }
    const moduleSource = host.read(options.parentModule, 'utf-8');
    const constName = `${(0, devkit_1.names)(options.fileName).propertyName}Routes`;
    const importPath = options.importPath;
    let sourceFile = ts.createSourceFile(options.parentModule, moduleSource, ts.ScriptTarget.Latest, true);
    sourceFile = (0, ast_utils_2.addImportToModule)(host, sourceFile, options.parentModule, options.moduleName);
    sourceFile = (0, ast_utils_2.addRoute)(host, options.parentModule, sourceFile, `{ path: '${(0, devkit_1.names)(options.fileName).fileName}', children: ${constName} }`);
    sourceFile = (0, ast_utils_1.insertImport)(host, sourceFile, options.parentModule, `${options.moduleName}, ${constName}`, importPath);
}
exports.addChildren = addChildren;
//# sourceMappingURL=add-children.js.map