"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const devkit_1 = require("@nrwl/devkit");
function normalizeOptions(tree, options) {
    var _a;
    const name = (0, devkit_1.names)(options.name).fileName;
    const projects = (0, devkit_1.getProjects)(tree);
    const libraryProject = projects.get(options.library);
    if (!libraryProject) {
        throw new Error(`The specified library "${options.library}" couldn't be found in the workspace.`);
    }
    if (libraryProject.projectType !== 'library') {
        throw new Error(`The specified project "${options.library}" is not a library.`);
    }
    const entryPointDestination = (0, devkit_1.joinPathFragments)(libraryProject.root, options.name);
    if (tree.exists(entryPointDestination)) {
        throw new Error(`The folder for the secondary entry point "${entryPointDestination}" already exists.`);
    }
    const { name: mainEntryPoint } = (0, devkit_1.readJson)(tree, (0, devkit_1.joinPathFragments)(libraryProject.root, 'package.json'));
    const secondaryEntryPoint = `${mainEntryPoint}/${options.name}`;
    return Object.assign(Object.assign({}, options), { entryPointDestination,
        mainEntryPoint,
        name,
        libraryProject,
        secondaryEntryPoint, skipModule: (_a = options.skipModule) !== null && _a !== void 0 ? _a : false });
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-options.js.map